-- The `event_stats` table is from `events`, because we do not want to store
-- the history of the changes of an event's statistics (i.e. causing the
-- database trigger "events_after_insert_delete_update" to insert into the
-- `events_history` table whenever the events table is modified.

CREATE TABLE IF NOT EXISTS event_stats (
  event_id                                bigint    NOT NULL REFERENCES events (id),
  enabled_user_email_notification_count   int       DEFAULT 0 NOT NULL,

  CONSTRAINT event_stats_non_negative_enabled_user_email_notification_count CHECK (enabled_user_email_notification_count >= 0)
);

CREATE UNIQUE INDEX event_stats_event_id_uniq_idx ON event_stats (event_id);
CREATE INDEX event_stats_enabled_user_email_notification_count_idx ON event_stats (enabled_user_email_notification_count);


-- Function and trigger to insert a new row into `event_stats` when a new
-- record in `events` is inserted.

CREATE FUNCTION insert_event_id_into_event_stats()
RETURNS TRIGGER AS $$
BEGIN
  INSERT INTO event_stats (event_id) VALUES(NEW.id);
  RETURN NEW;
END;
$$ LANGUAGE 'plpgsql';

CREATE TRIGGER events_after_insert
AFTER INSERT ON events
  FOR EACH ROW EXECUTE PROCEDURE insert_event_id_into_event_stats();
