package main

import (
	"fmt"
	"time"

	"code.justin.tv/cb/oracle/config"
	"code.justin.tv/cb/oracle/internal/clients"
)

func main() {
	BackfillEventStatsEmailNotifCount()
}

func mainTestEventExpiration() {
	c := InitClients()
	c.Cache.ExpireEventView(9)
}

func mainTestDuration() {
	fmt.Println(time.Now().Add(time.Duration(-1) * time.Hour))
}

func InitClients() clients.Clients {
	config.SetupRollbarLogging()
	config.Load()

	// Instantiate client interfaces:
	clientsObj, err := clients.NewClients()
	if err != nil {
		panic("Failed to instantiate clients on application start-up")
	}

	return *clientsObj
}
