package oracle_test

import (
	"testing"

	"github.com/stretchr/testify/assert"

	"code.justin.tv/cb/oracle/client"
	"code.justin.tv/foundation/twitchclient"
)

func TestNewClient_Error(t *testing.T) {
	client, err := oracle.NewClient(twitchclient.ClientConf{})

	assert.Error(t, err, "error expected from no host")
	assert.Nil(t, client)
}

func TestNewClient_Success(t *testing.T) {
	client, err := oracle.NewClient(twitchclient.ClientConf{
		Host: "test-host",
	})

	assert.NoError(t, err)
	assert.NotNil(t, client)
}
