package oracle

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

// DeleteV1Event makes a DELETE request to the Oracle service's v1 API
// to delete an existing event.
func (c *client) DeleteV1Event(ctx context.Context, id int, reqOpts *twitchclient.ReqOpts) (*view.DeleteV1EventOutput, error) {
	path := fmt.Sprintf("/v1/events/%d", id)
	req, err := c.NewRequest(http.MethodDelete, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.delete_v1_event",
		StatSampleRate: 0.1,
	})

	output := &view.DeleteV1EventOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
