package oracle_test

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"github.com/stretchr/testify/assert"
	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/client"
	"code.justin.tv/foundation/twitchclient"
)

func TestGetV1EventSuggestions_Success(t *testing.T) {
	a := assert.New(t)

	server := httptest.NewServer(
		http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
			w.WriteHeader(http.StatusOK)
			payload := `
        {
          "status": 200,
          "message": "Found suggestions for game",
          "meta": {
            "status": "TEST"
          },
          "data": {
            "future": [ ],
            "past": [ ],
            "live": [ ]
          }
        }
      `

			_, err := w.Write([]byte(payload))
			a.NoError(err)
		}),
	)

	defer server.Close()

	client, err := oracle.NewClient(twitchclient.ClientConf{Host: server.URL})
	a.NoError(err)

	gameID := 123
	resp, err := client.GetV1EventSuggestionsForGame(context.Background(), gameID, nil)
	a.NoError(err)
	a.Equal(http.StatusOK, resp.Status)
	a.NotNil(resp.Data)
	a.NotNil(resp.Meta)
	a.Equal("TEST", resp.Meta.Status)
}
