package oracle

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1Event makes a GET request (Content-Type: "application/json")
// to the Oracle service's v1 API to fetch an existing event by ID.
func (c *client) GetV1Event(ctx context.Context, id int, reqOpts *twitchclient.ReqOpts) (*view.GetV1EventOutput, error) {
	path := fmt.Sprintf("/v1/events/%d", id)
	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.get_v1_event",
		StatSampleRate: 0.1,
	})

	output := &view.GetV1EventOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
