package oracle

import (
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

// GetV1EventsSuggestionsForGame makes a GET request for Oracle's v1 API to
// fetch a set of event suggestions for a given gameID
func (c *client) GetV1EventSuggestionsForGame(ctx context.Context, gameID int, reqOpts *twitchclient.ReqOpts) (*view.GetV1EventSuggestionsOutput, error) {
	path := fmt.Sprintf("/v1/suggestions/game/%d", gameID)
	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.get_v1_event_suggestions_for_game",
		StatSampleRate: 0.1,
	})

	output := &view.GetV1EventSuggestionsOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
