package oracle

import (
	"fmt"
	"net/http"

	"github.com/google/go-querystring/query"
	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

type GetV1UserEventNotificationSettingsParams struct {
	RequestingUserID int `url:"user_id,omitempty"`
}

// GetV1UserEventNotificationSettings makes a GET request to the Oracle
// service's v1 API to read an existing event's notification settings
// for a user.
func (c *client) GetV1UserEventNotificationSettings(ctx context.Context, userID int, eventID int, requestingUserID int, reqOpts *twitchclient.ReqOpts) (*view.GetV1UserEventNotificationSettingsOutput, error) {
	v, err := query.Values(&GetV1UserEventNotificationSettingsParams{
		RequestingUserID: requestingUserID,
	})
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/users/%d/notifications/events/%d/settings?%s", userID, eventID, v.Encode())
	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.get_v1_user_event_notification_settings",
		StatSampleRate: 0.1,
	})

	output := &view.GetV1UserEventNotificationSettingsOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
