package oracle

import (
	"fmt"
	"net/http"

	"github.com/google/go-querystring/query"
	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

type GetV1UserEventsNotificationSettingsParams struct {
	EventIDs         []int `url:"event_ids,comma"`
	RequestingUserID int   `url:"user_id"`
}

func (c *client) GetV1UserEventsNotificationSettings(ctx context.Context, userID int, eventIDs []int, requestingUserID int, reqOpts *twitchclient.ReqOpts) (*view.GetV1UserEventsNotificationSettingsOutput, error) {
	v, err := query.Values(&GetV1UserEventsNotificationSettingsParams{
		EventIDs:         eventIDs,
		RequestingUserID: requestingUserID,
	})
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/users/%d/notifications/events/settings?%s", userID, v.Encode())
	req, err := c.NewRequest(http.MethodGet, path, nil)
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.get_v1_user_events_notification_settings",
		StatSampleRate: 0.1,
	})

	output := &view.GetV1UserEventsNotificationSettingsOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
