package oracle_test

import (
	"net/http"
	"net/http/httptest"
	"testing"

	"github.com/stretchr/testify/assert"
	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/client"
	"code.justin.tv/foundation/twitchclient"
)

func TestGetV1UserEventsNotificationSettings(t *testing.T) {
	a := assert.New(t)

	server := httptest.NewServer(http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		expectedPath := "/v1/users/111/notifications/events/settings"
		a.Equal(expectedPath, r.URL.EscapedPath())
		a.Equal(http.MethodGet, r.Method)

		expectedParams := "event_ids=123%2C234&user_id=111"
		a.Equal(expectedParams, r.URL.RawQuery)

		w.WriteHeader(http.StatusOK)

		payload := `
    {
      "status": 200,
      "message": "",
      "data": [
        {
          "event_id": 123,
          "email_enabled": true
        },
        {
          "event_id": 234,
          "email_enabled": false
        }
      ]
    }
    `

		_, err := w.Write([]byte(payload))
		a.NoError(err)
	}))

	defer server.Close()

	client, err := oracle.NewClient(twitchclient.ClientConf{Host: server.URL})
	a.NoError(err)

	resp, err := client.GetV1UserEventsNotificationSettings(context.Background(), 111, []int{123, 234}, 111, nil)
	a.NoError(err)

	if a.NotNil(resp) {
		a.Equal(http.StatusOK, resp.Status)
		a.Empty(resp.Message)
	}
}
