package oracle

import (
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

// PostV1ChannelEventCoverImage makes a POST request
// (Content-Type: "application/json") to the Oracle service's v1 API
// to upload an event cover image for a given channel.
func (c *client) PostV1ChannelEventCoverImage(ctx context.Context, channelID int, input *view.PostV1ChannelEventCoverImageInput, reqOpts *twitchclient.ReqOpts) (*view.PostV1ChannelEventCoverImageOutput, error) {
	reqBody, err := json.Marshal(input)
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/channels/%d/event_cover_images", channelID)
	req, err := c.NewRequest(http.MethodPost, path, bytes.NewReader(reqBody))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.post_v1_channel_event_cover_image",
		StatSampleRate: 0.1,
	})

	output := &view.PostV1ChannelEventCoverImageOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
