package oracle

import (
	"bytes"
	"encoding/json"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

// PostV1Event makes a POST request (Content-Type: "application/json")
// to the Oracle service's v1 API to create a new event for a given channel.
func (c *client) PostV1Event(ctx context.Context, input *view.PostV1EventInput, reqOpts *twitchclient.ReqOpts) (*view.PostV1EventOutput, error) {
	input.StartTimeUTC = input.StartTimeUTC.UTC()
	input.EndTimeUTC = input.EndTimeUTC.UTC()

	reqBody, err := json.Marshal(input)
	if err != nil {
		return nil, err
	}

	req, err := c.NewRequest(http.MethodPost, "/v1/events", bytes.NewReader(reqBody))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.post_v1_events",
		StatSampleRate: 0.1,
	})

	output := &view.PostV1EventOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
