package oracle

import (
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

// PutV1Event makes a PUT request
// to the Oracle service's v1 API to update an existing event.
func (c *client) PutV1Event(ctx context.Context, id int, input *view.PutV1EventInput, reqOpts *twitchclient.ReqOpts) (*view.PutV1EventOutput, error) {
	reqBody, err := json.Marshal(input)
	if err != nil {
		return nil, err
	}

	input.StartTimeUTC = input.StartTimeUTC.UTC()
	input.EndTimeUTC = input.EndTimeUTC.UTC()

	path := fmt.Sprintf("/v1/events/%d", id)
	req, err := c.NewRequest(http.MethodPut, path, bytes.NewReader(reqBody))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.put_v1_event",
		StatSampleRate: 0.1,
	})

	output := &view.PutV1EventOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
