package oracle

import (
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"

	"github.com/google/go-querystring/query"
	"golang.org/x/net/context"

	"code.justin.tv/cb/oracle/view"
	"code.justin.tv/foundation/twitchclient"
)

type PutV1UserEventNotificationSettingsParams struct {
	RequestingUserID int `url:"user_id,omitempty"`
}

// PutV1UserEventNotificationSettings makes a PUT request to the Oracle
// service's v1 API to update an existing event's notification for a user.
func (c *client) PutV1UserEventNotificationSettings(ctx context.Context, userID int, eventID int, requestingUserID int, input *view.PutV1UserEventNotificationSettingsInput, reqOpts *twitchclient.ReqOpts) (*view.PutV1UserEventNotificationSettingsOutput, error) {
	v, err := query.Values(&PutV1UserEventNotificationSettingsParams{
		RequestingUserID: requestingUserID,
	})
	if err != nil {
		return nil, err
	}

	reqBody, err := json.Marshal(input)
	if err != nil {
		return nil, err
	}

	path := fmt.Sprintf("/v1/users/%d/notifications/events/%d/settings?%s", userID, eventID, v.Encode())
	req, err := c.NewRequest(http.MethodPut, path, bytes.NewReader(reqBody))
	if err != nil {
		return nil, err
	}

	req.Header.Set("Content-Type", "application/json")

	mergedOpts := twitchclient.MergeReqOpts(reqOpts, twitchclient.ReqOpts{
		StatName:       "service.cb-oracle.put_v1_user_event_notification_settings",
		StatSampleRate: 0.1,
	})

	output := &view.PutV1UserEventNotificationSettingsOutput{}
	_, err = c.DoJSON(ctx, output, req, mergedOpts)
	if err != nil {
		return nil, err
	}

	return output, nil
}
