package api

import (
	"fmt"
	"net/http"
	"strconv"

	"goji.io/pat"

	"code.justin.tv/cb/oracle/internal/api/responder"
	"code.justin.tv/cb/oracle/view"
)

func (s *Server) V1UnfeatureChannel(w http.ResponseWriter, r *http.Request) {
	writer := responder.NewResponseWriter(w)

	channelIDStr := pat.Param(r, "channel_id")
	channelID, err := strconv.Atoi(channelIDStr)
	if err != nil {
		writer.BadRequest(fmt.Sprintf(responder.InvalidParameter, "channel_id", channelIDStr))
		return
	}

	_, err = s.DB.DeleteFeaturedChannel(r.Context(), channelID)
	if err != nil {
		writer.InternalServerError("Failed to delete feature", err)
		return
	}

	writer.OK(&view.V1FeaturedChannelResponse{
		Status:  200,
		Message: "Successfully Unfeatured",
	})
}
