package api_test

import (
	"fmt"
	"net/http"
	"net/http/httptest"
	"testing"

	"code.justin.tv/cb/oracle/internal/api"
	"code.justin.tv/cb/oracle/internal/api/responder"
	"github.com/stretchr/testify/assert"
)

// TODO: stub out clock everywhere so we can stub out `time.now`
func TestGetListEvents_NoChannel(t *testing.T) {
	a := assert.New(t)
	r := httptest.NewRequest(http.MethodGet, "/v1/events", nil)
	s, err := api.ParseV1ListEventsParams(r)

	a.Equal(err.Error(), fmt.Sprintf(responder.InvalidParameter, "channel_id", ""))
	a.Nil(s)
}

func TestGetListEvents_SuccessMinimumParams(t *testing.T) {
	a := assert.New(t)
	r := httptest.NewRequest(http.MethodGet, "/v1/events?channel_id=123", nil)
	s, err := api.ParseV1ListEventsParams(r)

	a.Nil(err)
	a.Equal(s.ChannelID, 123)
	a.Equal(s.OrderBy, "asc")
}
