package api

import (
	"net/http"

	"code.justin.tv/cb/oracle/internal/api/responder"
	"code.justin.tv/cb/oracle/view"
)

func (s *Server) V1ListFeaturedChannels(w http.ResponseWriter, r *http.Request) {
	writer := responder.NewResponseWriter(w)

	featuredChannels, err := s.DB.ListFeaturedChannels(r.Context())
	if err != nil {
		writer.InternalServerError("Failed to list featured channels", err)
		return
	}

	featuredChannelsView := make([]*view.V1FeaturedChannel, len(featuredChannels))

	for i, channel := range featuredChannels {
		featuredChannelsView[i] = &view.V1FeaturedChannel{
			ID:        channel.ID,
			CreatedAt: channel.CreatedAtUTC,
		}
	}

	response := &view.V1ListFeaturedChannelResponse{
		Data: featuredChannelsView,
	}

	writer.OK(response)
}
