package cache

import (
	"code.justin.tv/cb/oracle/internal/clients/db"
	"code.justin.tv/cb/oracle/view"
)

// Cache is the generic cache interface.
type APICache interface {
	// Get Event view response that expires within 60 seconds.
	GetEventView(eventID int) (*[]byte, error)
	// Cache specific event view for 60 seconds.
	CacheEventView(eventID int, eventView view.GetV1EventOutput) error
	// Expire event view.
	ExpireEventView(eventID int) error

	// Get List Events view response that expires within 60 seconds.
	GetListEventsView(params db.EventListParams) (*[]byte, error)
	// Cache list events view for 60 seconds.
	CacheListEventsView(params db.EventListParams, listEventsView view.GetV1AvailableEventListOutput) error
	// Expire list events for channel
	ExpireListEventsView(channelID int) error

	// Get List Event Extensions view response that expires within 60 seconds.
	GetListEventExtensionsView(eventID int) (*[]byte, error)
	// Cache list Event Extensions view for 60 seconds.
	CacheListEventExtensionsView(eventID int, listEventExtensionsView view.GetV1EventExtensionListOutput) error
	// Expire list event extensions for channel
	ExpireListEventExtensionsView(eventID int) error

	// Get Game Events view response that expires within 60 seconds.
	GetGameEventsView(gameID int) (*[]byte, error)
	// CacheGameEventsView caches list events view for 60 seconds.
	CacheGameEventsView(gameID int, eventSuggestions view.GetV1EventSuggestionsOutput) error
	// ExpireGameEventsView expire views by game.
	ExpireGameEventsView(gameID int) error
}

type CronCache interface {
	// Get Notification
	GetUserNotificationDelivery(interval string, eventID int, userID string) (*[]byte, error)
	CacheUserNotificationDelivery(interval string, eventID int, userID string) error

	GetNotificationDelivery(interval string, eventID int) (*[]byte, error)
	CacheNotificationDelivery(interval string, eventID int) error
}
