package pq

import (
	"database/sql"
	"fmt"

	log "github.com/Sirupsen/logrus"
)

const (
	driver             = "postgres"
	dataSourceTemplate = "postgres://%s@%s"
)

// DB is a wrapper for sql.DB.
type DB struct {
	*sql.DB
}

// OpenConnection opens a connection pool to the PostgresSQL database,
// specified by the database credentials and address.
//
// Pinging the database ensures that the connection was established.
func OpenConnection(credentials string, address string) (*DB, error) {
	log.Info("Opening connection to Postgres database at ", address)

	connection := fmt.Sprintf(dataSourceTemplate, credentials, address)
	db, err := sql.Open(driver, connection)
	if err != nil {
		return nil, err
	}

	if err := db.Ping(); err != nil {
		return nil, err
	}

	return &DB{db}, nil
}
