package discovery

import (
	"context"
	"net/http"
)

// Service is a generic Discovery service interface, to be implemented
// by a specific package (or mock).
type Service interface {
	// GetGameByID fetches a game object by ID.
	GetGameByID(ctx context.Context, id int) (*Game, error)
	// GetGameListByIDs fetches a list of games by their IDs, returning a map of
	// each Game keyed by its ID
	GetGameListByIDs(ctx context.Context, ids []int) (map[int]Game, error)
}

// Error is a simple representation of any non-successful (status 200)
// HTTP responses.
type Error struct {
	Status int
}

// Error implements the error interface.
func (c *Error) Error() string {
	return "discovery error: " + http.StatusText(c.Status)
}

// Game is a basic representation of a game object.
type Game struct {
	ID   int    `json:"id"`
	Name string `json:"name"`

	BoxArt struct {
		Large  string `json:"large"`
		Medium string `json:"medium"`
		Small  string `json:"small"`
	} `json:"boxArt"`
}
