package dynamodb

import (
	"context"

	awsDynamoDB "github.com/aws/aws-sdk-go/service/dynamodb"
)

type Client interface {
	SubscribeEvent(ctx context.Context, params SubscriptionItem) error
	UnsubscribeEvent(ctx context.Context, params SubscriptionItem) error

	GetEventNotificationsForUser(ctx context.Context, eventID int, userID string) (*SubscriptionItem, error)
	GetEventsNotificationsForUser(ctx context.Context, eventIDs []int, userIDs string) ([]*SubscriptionItem, error)

	GetUserNotificationsForEvent(ctx context.Context, eventID int, lastEvaluated map[string]*awsDynamoDB.AttributeValue) ([]*SubscriptionItem, map[string]*awsDynamoDB.AttributeValue, error)
}
