package s3_test

import (
	"context"
	"testing"

	"code.justin.tv/cb/oracle/internal/clients/s3"
	"github.com/stretchr/testify/assert"
)

func TestNewS3Client(t *testing.T) {
	a := assert.New(t)

	client, err := s3.NewS3Client("")
	a.NotNil(t, client)
	a.NoError(err)
}

const (
	KappaJpg  = "/9j/2wCEAAUDBAQEAwUEBAQFBQUGBwwIBwcHBw8LCwkMEQ8SEhEPERETFhwXExQaFRERGCEYGh0dHx8fExciJCIeJBweHx4BBQUFBwYHDggIDh4UERQeHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHv/AABEIABQAFAMBIgACEQEDEQH/xAGiAAABBQEBAQEBAQAAAAAAAAAAAQIDBAUGBwgJCgsQAAIBAwMCBAMFBQQEAAABfQECAwAEEQUSITFBBhNRYQcicRQygZGhCCNCscEVUtHwJDNicoIJChYXGBkaJSYnKCkqNDU2Nzg5OkNERUZHSElKU1RVVldYWVpjZGVmZ2hpanN0dXZ3eHl6g4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2drh4uPk5ebn6Onq8fLz9PX29/j5+gEAAwEBAQEBAQEBAQAAAAAAAAECAwQFBgcICQoLEQACAQIEBAMEBwUEBAABAncAAQIDEQQFITEGEkFRB2FxEyIygQgUQpGhscEJIzNS8BVictEKFiQ04SXxFxgZGiYnKCkqNTY3ODk6Q0RFRkdISUpTVFVWV1hZWmNkZWZnaGlqc3R1dnd4eXqCg4SFhoeIiYqSk5SVlpeYmZqio6Slpqeoqaqys7S1tre4ubrCw8TFxsfIycrS09TV1tfY2dri4+Tl5ufo6ery8/T19vf4+fr/2gAMAwEAAhEDEQA/APlPT7HToPCjazfWr3bvefZ0RZjGFG3OcgHNK40xBI0nhmdVjCM5N8flD8qfu981p6LpdxrPgBLGzeDzxqJk2ySBcjZjj86ibRtYW0kutYurWxtJY4vPDMPNCIAEATrnAHH5163sZckXGOlt7Lzvdvzt8jW2hz/iS1hsdevbS3BEUUpVATkgfWs+ruu3q6jrF1fIhjWaUuqk5IHvVKvNquLqS5drmb3JrO5ns7qO6tpDHNE25GHY0l3cT3dzJc3MrSzSHc7sckmoqKjmduW+ggooopAf/9k="
	ParrotGif = "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"
)

func TestValidateImage_InvalidEncoding(t *testing.T) {
	a := assert.New(t)
	client, err := s3.NewS3Client("")

	// var img *string
	img := "random string"
	if a.NotNil(client) && a.NoError(err) {
		validated, err := client.ValidateImage(context.Background(), img)
		a.Nil(validated)
		a.Error(err)
		a.Contains(err.Error(), s3.InvalidEncoding)
	}
}

func TestValidateImage_InvalidContentType(t *testing.T) {
	a := assert.New(t)
	client, err := s3.NewS3Client("")

	img := ParrotGif
	if a.NotNil(client) && a.NoError(err) {
		validated, err := client.ValidateImage(context.Background(), img)
		a.Nil(validated)
		a.Error(err)
		a.Contains(err.Error(), s3.InvalidContentType)
	}
}

func TestValidateImage_Success(t *testing.T) {
	a := assert.New(t)
	client, err := s3.NewS3Client("")

	img := KappaJpg
	if a.NotNil(client) && a.NoError(err) {
		validated, err := client.ValidateImage(context.Background(), img)
		a.NotNil(validated)
		a.NoError(err)
	}

}
