package s3

import "context"

// S3i is a generic S3 service interface, to be implemented
// by a specific package (or mock).
type S3i interface {
	ValidateAndUploadCoverImage(ctx context.Context, channelID string, encodedImg string) (*string, error)
	SaveFromPending(ctx context.Context, channelID string, versionID string) error
	ExpireSavedImage(ctx context.Context, channelID string, versionID string) error
}
