package sns

import (
	"net/http"

	"code.justin.tv/cb/oracle/internal/clients/db"
)

// Service is a generic Discovery service interface, to be implemented
// by a specific package (or mock).
type SNSi interface {
	PublishEmailNotification(event *db.Event, notificationType NotificationType, userID int, gameName string) error
}

// Error is a simple representation of any non-successful (status 200)
// HTTP responses.
type Error struct {
	Status int
}

// Error implements the error interface.
func (c *Error) Error() string {
	return "sns error: " + http.StatusText(c.Status)
}
