package stats

import (
	"fmt"
	"os"
	"time"

	"code.justin.tv/cb/oracle/config"
	log "github.com/Sirupsen/logrus"

	"github.com/cactus/go-statsd-client/statsd"
)

type Client struct {
	statsd.Statter
}

func NewStatsClient(prefix string) (*Client, error) {
	// InitStatsd creates a stats.Statter with an environment
	var stats statsd.Statter

	statsdHostport := config.Values.StatsHostPort
	if len(statsdHostport) > 0 {
		hostName, err := os.Hostname()
		if err != nil {
			hostName = "unknown_host"
		}
		if config.Environment == "development" {
			hostName = "localhost"
		}

		prefix := fmt.Sprintf("%v.%v.%v", prefix, config.Environment, hostName)

		if stats, err = statsd.NewBufferedClient(statsdHostport, prefix, 1*time.Second, 512); err != nil {
			log.Fatalf("StatsD configuration error: %v", err)
		}

		log.Printf("Connected to StatsD at %s with prefix %s\n", statsdHostport, prefix)
	} else {
		// Just because Go is silly
		var err error
		stats, err = statsd.NewNoopClient()
		if err != nil {
			log.Fatalf("Noop client failed: %v", err)
		}
	}

	return &Client{
		Statter: stats,
	}, nil
}
