package stats

import (
	log "github.com/Sirupsen/logrus"
	"github.com/cactus/go-statsd-client/statsd"
)

var defaultTriggerLevels = []log.Level{
	log.ErrorLevel,
	log.FatalLevel,
	log.PanicLevel,
}

// Hook wrapper for the statsd Client
type Hook struct {
	statsd.SubStatter
}

// NewHook for use with when adding to you own logger instance.
func NewHook(s statsd.Statter) *Hook {
	return &Hook{
		SubStatter: s.NewSubStatter("errors"),
	}
}

// SetupLogging creates a substatter for logging errors.
func SetupLogging(s statsd.Statter) {
	log.SetFormatter(&log.TextFormatter{DisableTimestamp: true})
	log.AddHook(NewHook(s))
}

// Levels returns the logrus log levels that this hook handles
func (r *Hook) Levels() []log.Level {
	return defaultTriggerLevels
}

func (r *Hook) Fire(entry *log.Entry) error {
	statsMetric := ""

	switch {
	case entry.Level == log.ErrorLevel:
		statsMetric = "error"
	case entry.Level == log.FatalLevel:
		statsMetric = "fatal"
	case entry.Level == log.PanicLevel:
		statsMetric = "panic"
	}

	// the one place we don't log the error
	err := r.Inc(statsMetric, 1, .1)
	return err
}
