package tmi

import (
	"context"
	"net/http"

	"code.justin.tv/cb/oracle/internal/clients/db"
)

type Service interface {
	CensorEventInformation(ctx context.Context, event *db.Event) error
}

// Error is a simple representation of any non-successful (status 200)
// HTTP responses.
type Error struct {
	Status int
}

// Error implements the error interface.
func (c *Error) Error() string {
	return "tmi error: " + http.StatusText(c.Status)
}

type GlobalBannedWordsResponse struct {
	GlobalBannedWords []GlobalBannedWord `json:"banned_words"`
}

type GlobalBannedWord struct {
	Word      string `json:"word"`
	CanOptOut bool   `json:"can_optout"`
}
