package tracking

import (
	"context"
)

const (
	OracleServerEventName       = "oracle_event_server"
	OracleNotificationEventName = "oracle_user_notification_server"

	OracleServerCreateAction        = "create"
	OracleServerUpdateAction        = "update"
	OracleServerAdminDeleteAction   = "admin_remove"
	OracleServerCreatorDeleteAction = "user_remove"
)

// Service sends event data to Spade
type Service interface {
	SendServerActionEvent(ctx context.Context, event *OracleServerEvent)
	SendNotificationChangeEvent(ctx context.Context, event *OracleNotificationEvent)
}

// OracleServerEvent contains the fields for tracking server-side changes
// to an Event.
type OracleServerEvent struct {
	Action                 string   `json:"action"`
	ServerTimestamp        float64  `json:"server_timestamp"`
	UserID                 *int     `json:"user_id"`
	EventID                int      `json:"event_id"`
	ChannelID              int      `json:"channel_id"`
	EventStartTimestamp    float64  `json:"event_start_timestamp"`
	EventEndTimestamp      float64  `json:"event_end_timestamp"`
	Timezone               string   `json:"timezone"`
	Title                  string   `json:"title"`
	GameID                 int      `json:"game_id"`
	Description            *string  `json:"description"`
	Status                 string   `json:"status"`
	CreatedAtTimestamp     float64  `json:"created_at_timestamp"`
	UpdatedAtTimestamp     *float64 `json:"updated_at_timestamp"`
	CoverImageUUID         *string  `json:"cover_image_uuid"`
	FallbackCoverImageUUID *string  `json:"fallback_cover_image_uuid"`
}

// OracleNotificationEvent contains the fields for tracking server-side
// changes to a user's event notification settings.
type OracleNotificationEvent struct {
	ServerTimestamp   float64 `json:"server_timestamp"`
	EventID           int     `json:"event_id"`
	UserID            *int    `json:"user_id"`
	EmailNotification bool    `json:"email_notification"`
}
