package users

import (
	"context"
	"net/http"
)

// Service is a generic users service interface, to be implemented
// by a specific package (or mock).
type Service interface {
	// GetByID fetches a user object by ID.
	GetByID(ctx context.Context, id int) (*User, error)
}

// Error is a simple representation of any non-successful (status 200)
// HTTP responses.
type Error struct {
	Status int
}

// Error implements the error interface.
func (c *Error) Error() string {
	return "users error: " + http.StatusText(c.Status)
}

// User is a basic representation of a Twitch user object.
type User struct {
	ID int `json:"id"`
}
