package notifications

import (
	"context"
	"fmt"
	"time"

	log "github.com/Sirupsen/logrus"

	"code.justin.tv/cb/oracle/internal/clients/db"
)

type EventsFetchFn func() []*db.Event

// check events occuring in the next 15 minutes, with a 5 minute buffer
func (n *NotificationHandler) GetCurrentEvents() []*db.Event {
	timeEnd := time.Now()
	timeStart := timeEnd.Add(time.Duration(-5) * time.Minute)

	s := fmt.Sprintf("now: checking events between %v and %v", timeStart, timeEnd)
	fmt.Println(s)
	events, err := n.Clients.DB.SelectAllEventsWithinTimeRange(context.Background(), timeStart, timeEnd) // now
	if err != nil {
		log.WithError(err).Error("GetCurrentEvents failed")
		return []*db.Event{}
	}

	return events
}

// check events occuring in the next 15 minutes, with a 5 minute buffer
func (n *NotificationHandler) GetEventsIn15Minutes() []*db.Event {
	timeEnd := time.Now().Add(time.Duration(15) * time.Minute)
	timeStart := timeEnd.Add(time.Duration(-5) * time.Minute)

	s := fmt.Sprintf("15 minutes: checking events between %v and %v", timeStart, timeEnd)
	fmt.Println(s)
	events, err := n.Clients.DB.SelectAllEventsWithinTimeRange(context.Background(), timeStart, timeEnd) // 15 minutes from now
	if err != nil {
		log.WithError(err).Error("GetEventsIn15Minutes failed")
		return []*db.Event{}
	}

	return events
}

// check hour before events checks one hour into the future, with a 5 minute buffer
func (n *NotificationHandler) GetEventsInNextHour() []*db.Event {
	timeEnd := time.Now().Add(time.Duration(1) * time.Hour)
	timeStart := timeEnd.Add(time.Duration(-5) * time.Minute)

	s := fmt.Sprintf("hour: checking events between %v and %v", timeStart, timeEnd)
	fmt.Println(s)
	events, err := n.Clients.DB.SelectAllEventsWithinTimeRange(context.Background(), timeStart, timeEnd) // 1 hour from now
	if err != nil {
		log.WithError(err).Error("GetEventsInNextHour failed")
		return []*db.Event{}
	}

	return events
}

// test function for all events
func (n *NotificationHandler) GetEventsAllTime() []*db.Event {
	timeZero := time.Unix(0, 0)
	timeInf := time.Now().AddDate(1000, 0, 0) // one thousand years from now

	s := fmt.Sprintf("test all time: checking events between %v and %v", timeZero, timeInf)
	fmt.Println(s)
	events, err := n.Clients.DB.SelectAllEventsWithinTimeRange(context.Background(), timeZero, timeInf) // events from all time
	if err != nil {
		log.WithError(err).Error("checking all events failed")
		return []*db.Event{}
	}
	fmt.Println("length all events: ", len(events))

	return events
}
