package jobs

import (
	"strconv"

	"code.justin.tv/cb/oracle/internal/clients"
	"code.justin.tv/cb/oracle/internal/clients/db"
	"code.justin.tv/cb/oracle/internal/clients/sns"
)

//implements workerpool.Job

type SendNotificationSNS struct {
	UserID           string
	Event            *db.Event
	GameName         string
	NotificationType sns.NotificationType
	Clients          *clients.Clients
}

func (job *SendNotificationSNS) Process() error {
	userID, err := strconv.Atoi(job.UserID)
	if err != nil {
		return err
	}

	if job.Event != nil {
		err = job.Clients.SNS.PublishEmailNotification(job.Event, job.NotificationType, userID, job.GameName)
		if err != nil {
			return err
		}
	}
	return nil
}
