def awsAccounts = [
  dev: [
    branch: '${GIT_COMMIT}',
    keyId: 'twitch-feed-dev-access-key',
    secretId: 'twitch-feed-dev-secret-key',
    s3Bucket: 'twitch-feed-dev'
  ],

  prod: [
    branch: 'origin/master',
    keyId: 'twitch-feed-aws-access-key',
    secretId: 'twitch-feed-aws-secret-key',
    s3Bucket: 'twitch-feed-aws'
  ]
]

job {
  name 'feed-oracle-build'
  using 'TEMPLATE-autobuild'

  scm {
    git {
      remote {
        github 'cb/oracle', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }

      clean true
    }
  }

  steps {
    shell './_scripts/build_cron_docker.sh \$GIT_COMMIT'
    shell './_scripts/build_server_docker.sh \$GIT_COMMIT'
  }
}

awsAccounts.each { accountSuffix, specs ->
  job {
    name "feed-oracle-deploy-${accountSuffix}"
    using 'TEMPLATE-deploy-aws'

    scm {
      git {
        remote {
          github 'cb/oracle', 'ssh', 'git-aws.internal.justin.tv'
          credentials 'git-aws-read-key'

          if (specs['branch'] != null) {
            branch specs['branch']
          }
        }

        clean true
      }
    }

    wrappers {
      colorizeOutput()

      credentialsBinding {
        string 'AWS_ACCESS_KEY_ID', specs['keyId']
        string 'AWS_SECRET_ACCESS_KEY', specs['secretId']
      }
    }

    steps {
      shell './_scripts/deploy_beanstalk_server.sh \$GIT_COMMIT \$ENVIRONMENT \$JOB_NAME'
      shell './_scripts/deploy_beanstalk_cron.sh \$GIT_COMMIT \$ENVIRONMENT \$JOB_NAME'
    }
  }
}
