package mocks

import "github.com/stretchr/testify/mock"

import "code.justin.tv/cb/oracle/internal/clients/db"
import "code.justin.tv/cb/oracle/view"

// APICache is an autogenerated mock type for the APICache type
type APICache struct {
	mock.Mock
}

// CacheEventView provides a mock function with given fields: eventID, eventView
func (_m *APICache) CacheEventView(eventID int, eventView view.GetV1EventOutput) error {
	ret := _m.Called(eventID, eventView)

	var r0 error
	if rf, ok := ret.Get(0).(func(int, view.GetV1EventOutput) error); ok {
		r0 = rf(eventID, eventView)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// CacheListEventsView provides a mock function with given fields: params, listEventsView
func (_m *APICache) CacheListEventsView(params db.EventListParams, listEventsView view.GetV1AvailableEventListOutput) error {
	ret := _m.Called(params, listEventsView)

	var r0 error
	if rf, ok := ret.Get(0).(func(db.EventListParams, view.GetV1AvailableEventListOutput) error); ok {
		r0 = rf(params, listEventsView)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ExpireEventView provides a mock function with given fields: eventID
func (_m *APICache) ExpireEventView(eventID int) error {
	ret := _m.Called(eventID)

	var r0 error
	if rf, ok := ret.Get(0).(func(int) error); ok {
		r0 = rf(eventID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// ExpireListEventsView provides a mock function with given fields: channelID
func (_m *APICache) ExpireListEventsView(channelID int) error {
	ret := _m.Called(channelID)

	var r0 error
	if rf, ok := ret.Get(0).(func(int) error); ok {
		r0 = rf(channelID)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GetEventView provides a mock function with given fields: eventID
func (_m *APICache) GetEventView(eventID int) (*[]byte, error) {
	ret := _m.Called(eventID)

	var r0 *[]byte
	if rf, ok := ret.Get(0).(func(int) *[]byte); ok {
		r0 = rf(eventID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*[]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(int) error); ok {
		r1 = rf(eventID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetListEventsView provides a mock function with given fields: params
func (_m *APICache) GetListEventsView(params db.EventListParams) (*[]byte, error) {
	ret := _m.Called(params)

	var r0 *[]byte
	if rf, ok := ret.Get(0).(func(db.EventListParams) *[]byte); ok {
		r0 = rf(params)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*[]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(db.EventListParams) error); ok {
		r1 = rf(params)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
