package mocks

import "github.com/stretchr/testify/mock"

// CronCache is an autogenerated mock type for the CronCache type
type CronCache struct {
	mock.Mock
}

// Get provides a mock function with given fields: key
func (_m *CronCache) Get(key string) (*[]byte, error) {
	ret := _m.Called(key)

	var r0 *[]byte
	if rf, ok := ret.Get(0).(func(string) *[]byte); ok {
		r0 = rf(key)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*[]byte)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(string) error); ok {
		r1 = rf(key)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// Set provides a mock function with given fields: key, expiration, data
func (_m *CronCache) Set(key string, expiration int32, data []byte) error {
	ret := _m.Called(key, expiration, data)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int32, []byte) error); ok {
		r0 = rf(key, expiration, data)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
