package mocks

import "code.justin.tv/cb/oracle/internal/clients/discovery"
import "github.com/stretchr/testify/mock"

import "context"

// DiscoveryClient is an autogenerated mock type for the DiscoveryClient type
type DiscoveryClient struct {
	mock.Mock
}

// GetGameByID provides a mock function with given fields: ctx, id
func (_m *DiscoveryClient) GetGameByID(ctx context.Context, id int) (*discovery.Game, error) {
	ret := _m.Called(ctx, id)

	var r0 *discovery.Game
	if rf, ok := ret.Get(0).(func(context.Context, int) *discovery.Game); ok {
		r0 = rf(ctx, id)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*discovery.Game)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, int) error); ok {
		r1 = rf(ctx, id)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetGameListByIDs provides a mock function with given fields: ctx, ids
func (_m *DiscoveryClient) GetGameListByIDs(ctx context.Context, ids []int) (map[int]discovery.Game, error) {
	ret := _m.Called(ctx, ids)

	var r0 map[int]discovery.Game
	if rf, ok := ret.Get(0).(func(context.Context, []int) map[int]discovery.Game); ok {
		r0 = rf(ctx, ids)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[int]discovery.Game)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []int) error); ok {
		r1 = rf(ctx, ids)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}
