package mocks

import "code.justin.tv/cb/oracle/internal/clients/dynamodb"
import "github.com/stretchr/testify/mock"
import ddb "github.com/aws/aws-sdk-go/service/dynamodb"

import "context"

// DynamoClient is an autogenerated mock type for the DynamoClient type
type DynamoClient struct {
	mock.Mock
}

// GetEventNotificationsForUser provides a mock function with given fields: ctx, eventID, userID
func (_m *DynamoClient) GetEventNotificationsForUser(ctx context.Context, eventID string, userID string) (*dynamodb.SubscriptionItem, error) {
	ret := _m.Called(ctx, eventID, userID)

	var r0 *dynamodb.SubscriptionItem
	if rf, ok := ret.Get(0).(func(context.Context, string, string) *dynamodb.SubscriptionItem); ok {
		r0 = rf(ctx, eventID, userID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*dynamodb.SubscriptionItem)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, string) error); ok {
		r1 = rf(ctx, eventID, userID)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetUserNotificationsForEvent provides a mock function with given fields: ctx, eventID, lastEvaluated
func (_m *DynamoClient) GetUserNotificationsForEvent(ctx context.Context, eventID string, lastEvaluated map[string]*ddb.AttributeValue) ([]*dynamodb.SubscriptionItem, map[string]*ddb.AttributeValue, error) {
	ret := _m.Called(ctx, eventID, lastEvaluated)

	var r0 []*dynamodb.SubscriptionItem
	if rf, ok := ret.Get(0).(func(context.Context, string, map[string]*ddb.AttributeValue) []*dynamodb.SubscriptionItem); ok {
		r0 = rf(ctx, eventID, lastEvaluated)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*dynamodb.SubscriptionItem)
		}
	}

	var r1 map[string]*ddb.AttributeValue
	if rf, ok := ret.Get(1).(func(context.Context, string, map[string]*ddb.AttributeValue) map[string]*ddb.AttributeValue); ok {
		r1 = rf(ctx, eventID, lastEvaluated)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(map[string]*ddb.AttributeValue)
		}
	}

	var r2 error
	if rf, ok := ret.Get(2).(func(context.Context, string, map[string]*ddb.AttributeValue) error); ok {
		r2 = rf(ctx, eventID, lastEvaluated)
	} else {
		r2 = ret.Error(2)
	}

	return r0, r1, r2
}

// SubscribeEvent provides a mock function with given fields: ctx, params
func (_m *DynamoClient) SubscribeEvent(ctx context.Context, params dynamodb.SubscriptionItem) error {
	ret := _m.Called(ctx, params)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, dynamodb.SubscriptionItem) error); ok {
		r0 = rf(ctx, params)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// UnsubscribeEvent provides a mock function with given fields: ctx, params
func (_m *DynamoClient) UnsubscribeEvent(ctx context.Context, params dynamodb.SubscriptionItem) error {
	ret := _m.Called(ctx, params)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, dynamodb.SubscriptionItem) error); ok {
		r0 = rf(ctx, params)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
