package mocks

import context "golang.org/x/net/context"
import jax "code.justin.tv/web/jax/client"
import mock "github.com/stretchr/testify/mock"
import twitchclient "code.justin.tv/foundation/twitchclient"

// Jax is an autogenerated mock type for the Client type
type Jax struct {
	mock.Mock
}

// GetStream provides a mock function with given fields: ctx, channel, opts, reqOpts
func (_m *Jax) GetStream(ctx context.Context, channel string, opts *jax.StreamOptions, reqOpts *twitchclient.ReqOpts) (*jax.Streams, error) {
	ret := _m.Called(ctx, channel, opts, reqOpts)

	var r0 *jax.Streams
	if rf, ok := ret.Get(0).(func(context.Context, string, *jax.StreamOptions, *twitchclient.ReqOpts) *jax.Streams); ok {
		r0 = rf(ctx, channel, opts, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jax.Streams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *jax.StreamOptions, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, channel, opts, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetStreamByID provides a mock function with given fields: ctx, channelID, opts, reqOpts
func (_m *Jax) GetStreamByID(ctx context.Context, channelID string, opts *jax.StreamOptions, reqOpts *twitchclient.ReqOpts) (*jax.Streams, error) {
	ret := _m.Called(ctx, channelID, opts, reqOpts)

	var r0 *jax.Streams
	if rf, ok := ret.Get(0).(func(context.Context, string, *jax.StreamOptions, *twitchclient.ReqOpts) *jax.Streams); ok {
		r0 = rf(ctx, channelID, opts, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jax.Streams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, string, *jax.StreamOptions, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, channelID, opts, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetStreamSummary provides a mock function with given fields: ctx, opts, reqOpts
func (_m *Jax) GetStreamSummary(ctx context.Context, opts *jax.StreamSummaryOptions, reqOpts *twitchclient.ReqOpts) (*jax.StreamSummary, error) {
	ret := _m.Called(ctx, opts, reqOpts)

	var r0 *jax.StreamSummary
	if rf, ok := ret.Get(0).(func(context.Context, *jax.StreamSummaryOptions, *twitchclient.ReqOpts) *jax.StreamSummary); ok {
		r0 = rf(ctx, opts, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jax.StreamSummary)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *jax.StreamSummaryOptions, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, opts, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetStreams provides a mock function with given fields: ctx, opts, reqOpts
func (_m *Jax) GetStreams(ctx context.Context, opts *jax.StreamsOptions, reqOpts *twitchclient.ReqOpts) (*jax.Streams, error) {
	ret := _m.Called(ctx, opts, reqOpts)

	var r0 *jax.Streams
	if rf, ok := ret.Get(0).(func(context.Context, *jax.StreamsOptions, *twitchclient.ReqOpts) *jax.Streams); ok {
		r0 = rf(ctx, opts, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jax.Streams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, *jax.StreamsOptions, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, opts, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetStreamsByChannelIDs provides a mock function with given fields: ctx, ids, opts, reqOpts
func (_m *Jax) GetStreamsByChannelIDs(ctx context.Context, ids []string, opts *jax.StreamsOptions, reqOpts *twitchclient.ReqOpts) (*jax.Streams, error) {
	ret := _m.Called(ctx, ids, opts, reqOpts)

	var r0 *jax.Streams
	if rf, ok := ret.Get(0).(func(context.Context, []string, *jax.StreamsOptions, *twitchclient.ReqOpts) *jax.Streams); ok {
		r0 = rf(ctx, ids, opts, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jax.Streams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string, *jax.StreamsOptions, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, ids, opts, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

// GetStreamsByChannels provides a mock function with given fields: ctx, channels, opts, reqOpts
func (_m *Jax) GetStreamsByChannels(ctx context.Context, channels []string, opts *jax.StreamsOptions, reqOpts *twitchclient.ReqOpts) (*jax.Streams, error) {
	ret := _m.Called(ctx, channels, opts, reqOpts)

	var r0 *jax.Streams
	if rf, ok := ret.Get(0).(func(context.Context, []string, *jax.StreamsOptions, *twitchclient.ReqOpts) *jax.Streams); ok {
		r0 = rf(ctx, channels, opts, reqOpts)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*jax.Streams)
		}
	}

	var r1 error
	if rf, ok := ret.Get(1).(func(context.Context, []string, *jax.StreamsOptions, *twitchclient.ReqOpts) error); ok {
		r1 = rf(ctx, channels, opts, reqOpts)
	} else {
		r1 = ret.Error(1)
	}

	return r0, r1
}

var _ jax.Client = (*Jax)(nil)
