package mocks

import "github.com/stretchr/testify/mock"

import "time"

import "github.com/cactus/go-statsd-client/statsd"

// MockStatsClient is an autogenerated mock type for the MockStatsClient type
type MockStatsClient struct {
	mock.Mock
}

// Close provides a mock function with given fields:
func (_m *MockStatsClient) Close() error {
	ret := _m.Called()

	var r0 error
	if rf, ok := ret.Get(0).(func() error); ok {
		r0 = rf()
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Dec provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) Dec(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Gauge provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) Gauge(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// GaugeDelta provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) GaugeDelta(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Inc provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) Inc(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// NewSubStatter provides a mock function with given fields: _a0
func (_m *MockStatsClient) NewSubStatter(_a0 string) statsd.SubStatter {
	ret := _m.Called(_a0)

	var r0 statsd.SubStatter
	if rf, ok := ret.Get(0).(func(string) statsd.SubStatter); ok {
		r0 = rf(_a0)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(statsd.SubStatter)
		}
	}

	return r0
}

// Raw provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) Raw(_a0 string, _a1 string, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// Set provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) Set(_a0 string, _a1 string, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, string, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetInt provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) SetInt(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// SetPrefix provides a mock function with given fields: _a0
func (_m *MockStatsClient) SetPrefix(_a0 string) {
	_m.Called(_a0)
}

// Timing provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) Timing(_a0 string, _a1 int64, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, int64, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TimingDuration provides a mock function with given fields: _a0, _a1, _a2
func (_m *MockStatsClient) TimingDuration(_a0 string, _a1 time.Duration, _a2 float32) error {
	ret := _m.Called(_a0, _a1, _a2)

	var r0 error
	if rf, ok := ret.Get(0).(func(string, time.Duration, float32) error); ok {
		r0 = rf(_a0, _a1, _a2)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}
