resource "aws_elastic_beanstalk_environment" "cron" {
  name = "${var.team_code}-${var.name}-${var.environment}-cron"
  application = "${aws_elastic_beanstalk_application.app.name}"

  solution_stack_name = "64bit Amazon Linux 2016.09 v2.3.0 running Docker 1.11.2"
  description = "Single cron instance"

  tags {
    Name = "${var.name}"
    Owner = "${var.owner}"
    Project = "${var.team_code}/${var.name}"
    Team = "${var.team}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:command"
    name = "DeploymentPolicy"
    value = "Rolling"
  }

  // Environment configurations
  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name = "ENVIRONMENT"
    value = "${var.environment}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name = "SANDSTORM_IAM_ROLE_ARN"
    value = "${var.sandstorm_iam_role_arn_prefix}/cb-oracle-${var.environment}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name = "ServiceRole"
    value = "aws-elasticbeanstalk-service-role"
  }

  // Health reporting
  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name = "SystemType"
    value = "enhanced"
  }

  // Autoscaling Group
  setting {
    namespace = "aws:autoscaling:asg"
    name = "Availability Zones"
    value = "Any 2"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name = "MinSize"
    value = "${var.cron_enabled ? 1 : 0}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name = "MaxSize"
    value = "${var.cron_enabled ? 1 : 0}"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name = "MeasureName"
    value = "CPUUtilization"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name = "LowerThreshold"
    value = "40"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name = "UpperThreshold"
    value = "60"
  }

  setting {
    namespace = "aws:autoscaling:trigger"
    name = "Unit"
    value = "Percent"
  }

  // Launch configuration
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name = "IamInstanceProfile"
    value = "${aws_iam_instance_profile.app.id}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name = "SecurityGroups"
    value = "${data.terraform_remote_state.account.twitch_subnets_sg}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name = "EC2KeyName"
    value = "${var.aws_key_name}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name = "InstanceType"
    value = "c4.xlarge"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name = "RollingUpdateType"
    value = "Health"
  }

  // EC2 VPC
  setting {
    namespace = "aws:ec2:vpc"
    name = "VPCId"
    value = "${data.terraform_remote_state.account.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name = "Subnets"
    value = "${data.terraform_remote_state.account.private_subnets}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name = "AssociatePublicIpAddress"
    value = "false"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name = "ELBScheme"
    value = "internal"
  }
}
