resource "aws_elasticache_cluster" "events_web" {
  cluster_id = "oracle-events-web"
  engine = "memcached"
  node_type = "${var.elasticache_web_node_type}"
  port = 11211
  num_cache_nodes = "${var.elasticache_web_num_cache_nodes}"
  parameter_group_name = "default.memcached1.4"
  security_group_ids = [
    "${data.terraform_remote_state.account.twitch_subnets_sg}"
  ]
  subnet_group_name = "${aws_elasticache_subnet_group.events_web_subnet.name}"
}

resource "aws_elasticache_subnet_group" "events_web_subnet" {
  name = "oracle-events-web-subnet-${var.environment}"
  subnet_ids = ["${split(",", "${data.terraform_remote_state.account.private_subnets}")}"]
}

resource "aws_elasticache_cluster" "events_cron" {
  cluster_id = "oracle-events-cron"
  engine = "memcached"
  node_type = "${var.elasticache_cron_node_type}"
  port = 11211
  num_cache_nodes = 1
  parameter_group_name = "default.memcached1.4"
  security_group_ids = [
    "${data.terraform_remote_state.account.twitch_subnets_sg}"
  ]
  subnet_group_name = "${aws_elasticache_subnet_group.events_cron_subnet.name}"
}

resource "aws_elasticache_subnet_group" "events_cron_subnet" {
  name = "oracle-events-cron-subnet-${var.environment}"
  subnet_ids = ["${split(",", "${data.terraform_remote_state.account.private_subnets}")}"]
}
