resource "aws_iam_role" "app" {
  name = "${var.team_code}-${var.name}-${var.environment}"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Sid": ""
    }
  ]
}
EOF
}

resource "aws_iam_instance_profile" "app" {
  name = "${aws_iam_role.app.name}"
  role = "${aws_iam_role.app.name}"
}

resource "aws_iam_role_policy" "sandstorm" {
  name = "sandstorm-policy"
  role = "${aws_iam_role.app.name}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Effect": "Allow",
      "Resource": "${var.sandstorm_iam_role_arn_prefix}/cb-oracle-${var.environment}"
    },
    {
      "Action": "s3:GetObject",
      "Effect": "Allow",
      "Resource": "arn:aws:s3:::twitch-sandstorm/sandstorm-agent.rpm",
      "Sid": "Stmt1473817796000"
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "app_s3_policy" {
  name = "${aws_iam_role.app.name}-s3-policy"
  role = "${aws_iam_role.app.id}"

  policy = <<EOF
{
    "Version": "2012-10-17",
    "Statement": [
      {
        "Effect": "Allow",
        "Action": [
          "s3:Get*",
          "s3:Put*",
          "s3:List*",
          "s3:DeleteObject"
        ],
        "Resource": [
          "${aws_s3_bucket.oracle-image-upload.arn}*",
          "${aws_s3_bucket.oracle-image-upload.arn}/*"
        ]
      }
    ]
}
EOF
}

resource "aws_iam_role_policy" "dynamodb" {
  name = "${aws_iam_role.app.name}-dynamodb-policy"
  role = "${aws_iam_role.app.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "dynamodb:*",
      "Effect": "Allow",
      "Resource": [
        "${aws_dynamodb_table.event-users.arn}"
      ]
    },
    {
      "Action": "dynamodb:Query",
      "Effect": "Allow",
      "Resource": [
        "${aws_dynamodb_table.event-users.arn}/index/*"
      ]
    }
  ]
}
EOF
}

resource "aws_iam_role_policy" "sns" {
  name = "${aws_iam_role.app.name}-sns-policy"
  role = "${aws_iam_role.app.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sns:Publish",
      "Effect": "Allow",
      "Resource": [
        "${aws_sns_topic.oracle_event_notifications.arn}"
      ]
    }
  ]
}
EOF
}
