data "terraform_remote_state" "account" {
  backend = "s3"

  config {
    profile = "${lookup(var.account, var.environment)}"
    region  = "us-west-2"
    bucket  = "${lookup(var.account, var.environment)}"
    key     = "tfstate/feed/terraform/accounts/${lookup(var.account, var.environment)}"
  }
}

data "terraform_remote_state" "asg_lambda" {
  backend = "s3"

  config {
    profile = "${lookup(var.account, var.environment)}"
    region  = "us-west-2"
    bucket  = "${lookup(var.account, var.environment)}"
    key     = "tfstate/web/asg-r53-lambda/services/lambda/${lookup(var.account, var.environment)}"
  }
}