resource "aws_s3_bucket" "oracle-image-upload" {
  bucket = "${var.s3_bucket_name}-${var.environment}"
  acl = "private"
  versioning {
    enabled = true
  }
  lifecycle_rule {
    id = "expire-pending-images"
    prefix = "images-pending/"
    enabled = true
    expiration {
      days = 90
      expired_object_delete_marker = true
    }
    noncurrent_version_expiration {
      days = 90
    }
  }

  lifecycle_rule {
    id = "expire-expiring-images"
    prefix = "images-expiring/"
    enabled = true
    expiration {
      days = 90
      expired_object_delete_marker = true
    }
    noncurrent_version_expiration {
      days = 1
    }
  }

  lifecycle_rule {
    id = "expire-noncurrent-saved-image"
    prefix = "images-saved/"
    enabled = true
    expiration {
      expired_object_delete_marker = true
    }
    noncurrent_version_expiration {
      days = 1
    }
  }
}
