resource "aws_sns_topic" "oracle_event_notifications" {
  name = "oracle_event_notifications"
}

variable "twitch_chat_aws_account_id" {
  default = "603200399373"
}

resource "aws_sns_topic_policy" "oracle_event_notifications_policy" {
  arn = "${aws_sns_topic.oracle_event_notifications.arn}"

  policy = <<POLICY
{
  "Version": "2008-10-17",
  "Id": "sns_cross_account_policy",
  "Statement": [
    {
      "Sid": "chat_account_notifications",
      "Effect": "Allow",
      "Principal": {
        "AWS": "arn:aws:iam::${var.twitch_chat_aws_account_id}:root"
      },
      "Action": [
        "SNS:Subscribe",
        "SNS:Receive"
      ],
      "Resource": "${aws_sns_topic.oracle_event_notifications.arn}"
    }
  ]
}
POLICY
}
