variable "account" {
  type = "map"

  default = {
    "production"  = "twitch-feed-aws"
    "staging"     = "twitch-feed-dev"
    "integration" = "twitch-feed-dev"
  }
}

variable "aws_account_id" {
  type        = "string"
  description = "AWS account id"
}

variable "asg_max_size" {
  type        = "string"
  description = "Largest size a service cluster will grow to"
}

variable "asg_min_size" {
  type        = "string"
  description = "Smallest size a service cluster will shrink down to"
}

variable "aws_key_name" {
  type    = "string"
  default = "oracle"
}

variable "aws_profile" {
  type        = "string"
  description = "AWS profile name"
}

variable "aws_region" {
  type    = "string"
  default = "us-west-2"
}

variable "elastic_beanstalk_web_ec2_instance_type" {
  type    = "string"
  default = "c4.xlarge"
}

variable "environment" {
  type        = "string"
  description = "Service environment"
}

variable "name" {
  type        = "string"
  default     = "oracle"
  description = "Name used for AWS resourcing (application, tagging, IAM, etc.)"
}

variable "owner" {
  type        = "string"
  default     = "creatorbusiness@twitch.tv"
  description = "Team email alias"
}

variable "sandstorm_iam_role_arn_prefix" {
  type        = "string"
  default     = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role"
  description = "Prefix to Sandstorm's AWS IAM Role ARN for assuming role"
}

variable "team" {
  type        = "string"
  default     = "Creator Business"
  description = "Twitch team name"
}

variable "team_code" {
  type        = "string"
  default     = "feed"
  description = "Twitch team code"
}

variable "s3_bucket_name" {
  type        = "string"
  default     = "oracle-image-uploads2"
  description = "Image uploads for Oracle events"
}

variable "elasticache_web_node_type" {
  type        = "string"
  default     = "cache.m4.large"
  description = "Node type for the web environment's ElastiCache"
}

variable "elasticache_web_num_cache_nodes" {
  type        = "string"
  default     = "1"
  description = "Node count for the web environment's ElastiCache cluster"
}

variable "elasticache_cron_node_type" {
  type        = "string"
  default     = "cache.t2.micro"
  description = "Node type for cron environment's ElastiCache"
}

variable "dynamodb_events_read" {
  type    = "string"
  default = "200"
}

variable "dynamodb_events_write" {
  type    = "string"
  default = "200"
}

variable "cron_enabled" {
  type    = "string"
  default = "true"
}
