package xray

import (
	"bytes"
	"encoding/json"
	"io"
	"net"
)

var emitter io.Writer

func init() {
	refreshEmitter()
}

func refreshEmitter() {
	emitter, _ = net.DialUDP("udp", nil, config.DaemonAddr())
}

func emit(seg *segment) {
	var b bytes.Buffer
	b.WriteString(`{"format": "json", "version": 1}`)
	b.WriteString("\n")
	json.NewEncoder(&b).Encode(seg)

	emitter.Write(b.Bytes())
}
