package view

// ErrorResponse is the base signature of the JSON body
// of any HTTP responses with a 4xx or 5xx status.
type ErrorResponse struct {
	Status      int    `json:"status"`
	ErrorString string `json:"error"`
}

// Error allows ErrorResponse to implement the error interface.
func (err *ErrorResponse) Error() string {
	return err.ErrorString
}
