package view

// PostV1ChannelEventCoverImageInput contains base64 encoding of a cover image file
// for the HTTP POST request body to the Oracle service.
type PostV1ChannelEventCoverImageInput struct {
	Base64EncodedImage string `json:"event_cover_image"`
}

// PostV1ChannelEventCoverImageOutput is the response body to the "upload an event
// cover image" HTTP POST request.
type PostV1ChannelEventCoverImageOutput struct {
	Status  int                                    `json:"status"`
	Message string                                 `json:"message"`
	Data    PostV1ChannelEventCoverImageOutputData `json:"data"`
}

// PostV1ChannelEventCoverImageOutputData contains the cover image ID in the
// response to the "upload an event cover image" HTTP POST request.
type PostV1ChannelEventCoverImageOutputData struct {
	ID string `json:"id"`
}
