package view

//V1EventExtensionView main view representing.
type V1EventExtensionView struct {
	EventID int     `json:"event_id"`
	Key     string  `json:"key"`
	Value   *string `json:"value"`
}

// DeleteV1EventExtensionOutput contains the fields from the response of making
// a DELETE request to the Oracle service's v1 API.
type DeleteV1EventExtensionOutput struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
}

// GetV1EventExtensionListOutput contains the fields from the response of making a
// GET request via GetV1EventExtensionList.
type GetV1EventExtensionListOutput struct {
	Status  int                     `json:"status"`
	Message string                  `json:"message"`
	Data    []*V1EventExtensionView `json:"data"`
}

// PostV1EventExtensionInput contains the required fields for making a POST request
// to the Oracle service's v1 API.
type PostV1EventExtensionInput struct {
	*V1EventExtensionView
}

// PostV1EventExtensionOutput contains the fields from the response of making a
// POST request via PostV1EventExtension.
type PostV1EventExtensionOutput struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
}

// PutV1EventExtensionInput contains the required fields for updating an existing event from Oracle v1
type PutV1EventExtensionInput struct {
	*V1EventExtensionView
}

// PutV1EventExtensionOutput contains the response after updating an existing event from Oracle v1
type PutV1EventExtensionOutput struct {
	Status  int    `json:"status"`
	Message string `json:"message"`
}
