package view

import (
	"errors"
	"strings"
)

const (
	// MinKeyLength is the minimum number of characters for
	// an extension key.
	MinKeyLength = 1

	// MaxKeyLength is the maximum number of characters for
	// an extension key.
	MaxKeyLength = 255
)

// The constants below are error strings for validating request parameters.
const (
	InvalidKeyLength = "Event key must be a string containing at least 1 character and no more than 255 characters."
)

// Validate verifies that each of the fields in PostV1EventExtensionInput is within
// the application constraints.
func (input *PostV1EventExtensionInput) Validate() error {
	msgs := []string{}

	if len(input.Key) < MinKeyLength || len(input.Key) > MaxKeyLength {
		msgs = append(msgs, InvalidKeyLength)
	}

	if len(msgs) > 0 {
		return errors.New(strings.Join(msgs, " "))
	}

	return nil
}

// Validate verifies that each of the fields in PutV1EventExtensionInput is within
// the application constraints.
func (input *PutV1EventExtensionInput) Validate() error {
	return nil
}
